/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LookAndFeel;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorChooserComponentFactory;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ColorChooserUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.CenterLayout;
import sun.swing.DefaultLookup;

public class BasicColorChooserUI
extends ColorChooserUI {
    protected JColorChooser chooser;
    JTabbedPane tabbedPane;
    JPanel singlePanel;
    JPanel previewPanelHolder;
    JComponent previewPanel;
    boolean isMultiPanel = false;
    private static TransferHandler defaultTransferHandler = new ColorTransferHandler();
    protected AbstractColorChooserPanel[] defaultChoosers;
    protected ChangeListener previewListener;
    protected PropertyChangeListener propertyChangeListener;
    private Handler handler;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicColorChooserUI();
    }

    protected AbstractColorChooserPanel[] createDefaultChoosers() {
        AbstractColorChooserPanel[] abstractColorChooserPanelArray = ColorChooserComponentFactory.getDefaultChooserPanels();
        return abstractColorChooserPanelArray;
    }

    protected void uninstallDefaultChoosers() {
        AbstractColorChooserPanel[] abstractColorChooserPanelArray = this.chooser.getChooserPanels();
        for (int i = 0; i < abstractColorChooserPanelArray.length; ++i) {
            this.chooser.removeChooserPanel(abstractColorChooserPanelArray[i]);
        }
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.chooser = (JColorChooser)jComponent;
        super.installUI(jComponent);
        this.installDefaults();
        this.installListeners();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setName("ColorChooser.tabPane");
        this.tabbedPane.setInheritsPopupMenu(true);
        this.tabbedPane.getAccessibleContext().setAccessibleDescription(this.tabbedPane.getName());
        this.singlePanel = new JPanel(new CenterLayout());
        this.singlePanel.setName("ColorChooser.panel");
        this.singlePanel.setInheritsPopupMenu(true);
        this.chooser.setLayout(new BorderLayout());
        this.defaultChoosers = this.createDefaultChoosers();
        this.chooser.setChooserPanels(this.defaultChoosers);
        this.previewPanelHolder = new JPanel(new CenterLayout());
        this.previewPanelHolder.setName("ColorChooser.previewPanelHolder");
        if (DefaultLookup.getBoolean(this.chooser, this, "ColorChooser.showPreviewPanelText", true)) {
            String string = UIManager.getString((Object)"ColorChooser.previewText", this.chooser.getLocale());
            this.previewPanelHolder.setBorder(new TitledBorder(string));
        }
        this.previewPanelHolder.setInheritsPopupMenu(true);
        this.installPreviewPanel();
        this.chooser.applyComponentOrientation(jComponent.getComponentOrientation());
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.chooser.remove(this.tabbedPane);
        this.chooser.remove(this.singlePanel);
        this.chooser.remove(this.previewPanelHolder);
        this.uninstallDefaultChoosers();
        this.uninstallListeners();
        this.uninstallPreviewPanel();
        this.uninstallDefaults();
        this.previewPanelHolder = null;
        this.previewPanel = null;
        this.defaultChoosers = null;
        this.chooser = null;
        this.tabbedPane = null;
        this.handler = null;
    }

    protected void installPreviewPanel() {
        JComponent jComponent = this.chooser.getPreviewPanel();
        if (jComponent == null) {
            jComponent = ColorChooserComponentFactory.getPreviewPanel();
        } else if (JPanel.class.equals(jComponent.getClass()) && 0 == jComponent.getComponentCount()) {
            jComponent = null;
        }
        this.previewPanel = jComponent;
        if (jComponent != null) {
            this.chooser.add((Component)this.previewPanelHolder, "South");
            jComponent.setForeground(this.chooser.getColor());
            this.previewPanelHolder.add(jComponent);
            jComponent.addMouseListener(this.getHandler());
            jComponent.setInheritsPopupMenu(true);
        }
    }

    protected void uninstallPreviewPanel() {
        if (this.previewPanel != null) {
            this.previewPanel.removeMouseListener(this.getHandler());
            this.previewPanelHolder.remove(this.previewPanel);
        }
        this.chooser.remove(this.previewPanelHolder);
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.chooser, "ColorChooser.background", "ColorChooser.foreground", "ColorChooser.font");
        LookAndFeel.installProperty(this.chooser, "opaque", Boolean.TRUE);
        TransferHandler transferHandler = this.chooser.getTransferHandler();
        if (transferHandler == null || transferHandler instanceof UIResource) {
            this.chooser.setTransferHandler(defaultTransferHandler);
        }
    }

    protected void uninstallDefaults() {
        if (this.chooser.getTransferHandler() instanceof UIResource) {
            this.chooser.setTransferHandler(null);
        }
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.chooser.addPropertyChangeListener(this.propertyChangeListener);
        this.previewListener = this.getHandler();
        this.chooser.getSelectionModel().addChangeListener(this.previewListener);
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    protected void uninstallListeners() {
        this.chooser.removePropertyChangeListener(this.propertyChangeListener);
        this.chooser.getSelectionModel().removeChangeListener(this.previewListener);
        this.previewListener = null;
    }

    private void selectionChanged(ColorSelectionModel colorSelectionModel) {
        AbstractColorChooserPanel[] abstractColorChooserPanelArray;
        JComponent jComponent = this.chooser.getPreviewPanel();
        if (jComponent != null) {
            jComponent.setForeground(colorSelectionModel.getSelectedColor());
            jComponent.repaint();
        }
        if ((abstractColorChooserPanelArray = this.chooser.getChooserPanels()) != null) {
            for (AbstractColorChooserPanel abstractColorChooserPanel : abstractColorChooserPanelArray) {
                if (abstractColorChooserPanel == null) continue;
                abstractColorChooserPanel.updateChooser();
            }
        }
    }

    static class ColorTransferHandler
    extends TransferHandler
    implements UIResource {
        ColorTransferHandler() {
            super("color");
        }
    }

    private class Handler
    implements ChangeListener,
    MouseListener,
    PropertyChangeListener {
        private Handler() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            BasicColorChooserUI.this.selectionChanged((ColorSelectionModel)changeEvent.getSource());
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (BasicColorChooserUI.this.chooser.getDragEnabled()) {
                TransferHandler transferHandler = BasicColorChooserUI.this.chooser.getTransferHandler();
                transferHandler.exportAsDrag(BasicColorChooserUI.this.chooser, mouseEvent, 1);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "chooserPanels") {
                Container container;
                Container container2;
                int n;
                AbstractColorChooserPanel[] abstractColorChooserPanelArray = (AbstractColorChooserPanel[])propertyChangeEvent.getOldValue();
                AbstractColorChooserPanel[] abstractColorChooserPanelArray2 = (AbstractColorChooserPanel[])propertyChangeEvent.getNewValue();
                for (n = 0; n < abstractColorChooserPanelArray.length; ++n) {
                    container2 = abstractColorChooserPanelArray[n].getParent();
                    if (container2 == null) continue;
                    container = container2.getParent();
                    if (container != null) {
                        container.remove(container2);
                    }
                    abstractColorChooserPanelArray[n].uninstallChooserPanel(BasicColorChooserUI.this.chooser);
                }
                n = abstractColorChooserPanelArray2.length;
                if (n == 0) {
                    BasicColorChooserUI.this.chooser.remove(BasicColorChooserUI.this.tabbedPane);
                    return;
                }
                if (n == 1) {
                    BasicColorChooserUI.this.chooser.remove(BasicColorChooserUI.this.tabbedPane);
                    container2 = new JPanel(new CenterLayout());
                    ((JComponent)container2).setInheritsPopupMenu(true);
                    container2.add(abstractColorChooserPanelArray2[0]);
                    BasicColorChooserUI.this.singlePanel.add((Component)container2, "Center");
                    BasicColorChooserUI.this.chooser.add(BasicColorChooserUI.this.singlePanel);
                } else {
                    if (abstractColorChooserPanelArray.length < 2) {
                        BasicColorChooserUI.this.chooser.remove(BasicColorChooserUI.this.singlePanel);
                        BasicColorChooserUI.this.chooser.add((Component)BasicColorChooserUI.this.tabbedPane, "Center");
                    }
                    for (int i = 0; i < abstractColorChooserPanelArray2.length; ++i) {
                        container = new JPanel(new CenterLayout());
                        ((JComponent)container).setInheritsPopupMenu(true);
                        String string2 = abstractColorChooserPanelArray2[i].getDisplayName();
                        int n2 = abstractColorChooserPanelArray2[i].getMnemonic();
                        container.add(abstractColorChooserPanelArray2[i]);
                        BasicColorChooserUI.this.tabbedPane.addTab(string2, container);
                        if (n2 <= 0) continue;
                        BasicColorChooserUI.this.tabbedPane.setMnemonicAt(i, n2);
                        int n3 = abstractColorChooserPanelArray2[i].getDisplayedMnemonicIndex();
                        if (n3 < 0) continue;
                        BasicColorChooserUI.this.tabbedPane.setDisplayedMnemonicIndexAt(i, n3);
                    }
                }
                BasicColorChooserUI.this.chooser.applyComponentOrientation(BasicColorChooserUI.this.chooser.getComponentOrientation());
                for (int i = 0; i < abstractColorChooserPanelArray2.length; ++i) {
                    abstractColorChooserPanelArray2[i].installChooserPanel(BasicColorChooserUI.this.chooser);
                }
            } else if (string == "previewPanel") {
                BasicColorChooserUI.this.uninstallPreviewPanel();
                BasicColorChooserUI.this.installPreviewPanel();
            } else if (string == "selectionModel") {
                ColorSelectionModel colorSelectionModel = (ColorSelectionModel)propertyChangeEvent.getOldValue();
                colorSelectionModel.removeChangeListener(BasicColorChooserUI.this.previewListener);
                ColorSelectionModel colorSelectionModel2 = (ColorSelectionModel)propertyChangeEvent.getNewValue();
                colorSelectionModel2.addChangeListener(BasicColorChooserUI.this.previewListener);
                BasicColorChooserUI.this.selectionChanged(colorSelectionModel2);
            } else if (string == "componentOrientation") {
                ComponentOrientation componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue();
                JColorChooser jColorChooser = (JColorChooser)propertyChangeEvent.getSource();
                if (componentOrientation != (ComponentOrientation)propertyChangeEvent.getOldValue()) {
                    jColorChooser.applyComponentOrientation(componentOrientation);
                    jColorChooser.updateUI();
                }
            }
        }
    }

    public class PropertyHandler
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            BasicColorChooserUI.this.getHandler().propertyChange(propertyChangeEvent);
        }
    }
}

