/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.message;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.addressing.WSEndpointReference;
import com.sun.xml.internal.ws.api.message.AddressingUtils;
import com.sun.xml.internal.ws.api.message.Header;
import com.sun.xml.internal.ws.api.message.MessageHeaders;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.binding.SOAPBindingImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.namespace.QName;

public class HeaderList
extends ArrayList<Header>
implements MessageHeaders {
    private static final long serialVersionUID = -6358045781349627237L;
    private int understoodBits;
    private BitSet moreUnderstoodBits = null;
    private SOAPVersion soapVersion;

    @Deprecated
    public HeaderList() {
    }

    public HeaderList(SOAPVersion sOAPVersion) {
        this.soapVersion = sOAPVersion;
    }

    public HeaderList(HeaderList headerList) {
        super(headerList);
        this.understoodBits = headerList.understoodBits;
        if (headerList.moreUnderstoodBits != null) {
            this.moreUnderstoodBits = (BitSet)headerList.moreUnderstoodBits.clone();
        }
    }

    public HeaderList(MessageHeaders messageHeaders) {
        super(messageHeaders.asList());
        if (messageHeaders instanceof HeaderList) {
            HeaderList headerList = (HeaderList)messageHeaders;
            this.understoodBits = headerList.understoodBits;
            if (headerList.moreUnderstoodBits != null) {
                this.moreUnderstoodBits = (BitSet)headerList.moreUnderstoodBits.clone();
            }
        } else {
            Set<QName> set = messageHeaders.getUnderstoodHeaders();
            if (set != null) {
                for (QName qName : set) {
                    this.understood(qName);
                }
            }
        }
    }

    @Override
    public int size() {
        return super.size();
    }

    @Override
    public boolean hasHeaders() {
        return !this.isEmpty();
    }

    @Deprecated
    public void addAll(Header ... headerArray) {
        this.addAll(Arrays.asList(headerArray));
    }

    @Override
    public Header get(int n) {
        return (Header)super.get(n);
    }

    public void understood(int n) {
        if (n >= this.size()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n < 32) {
            this.understoodBits |= 1 << n;
        } else {
            if (this.moreUnderstoodBits == null) {
                this.moreUnderstoodBits = new BitSet();
            }
            this.moreUnderstoodBits.set(n - 32);
        }
    }

    public boolean isUnderstood(int n) {
        if (n >= this.size()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n < 32) {
            return this.understoodBits == (this.understoodBits | 1 << n);
        }
        if (this.moreUnderstoodBits == null) {
            return false;
        }
        return this.moreUnderstoodBits.get(n - 32);
    }

    @Override
    public void understood(@NotNull Header header) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.get(i) != header) continue;
            this.understood(i);
            return;
        }
        throw new IllegalArgumentException();
    }

    @Override
    @Nullable
    public Header get(@NotNull String string, @NotNull String string2, boolean bl) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            Header header = this.get(i);
            if (!header.getLocalPart().equals(string2) || !header.getNamespaceURI().equals(string)) continue;
            if (bl) {
                this.understood(i);
            }
            return header;
        }
        return null;
    }

    public Header get(String string, String string2) {
        return this.get(string, string2, true);
    }

    @Override
    @Nullable
    public Header get(@NotNull QName qName, boolean bl) {
        return this.get(qName.getNamespaceURI(), qName.getLocalPart(), bl);
    }

    @Nullable
    public Header get(@NotNull QName qName) {
        return this.get(qName, true);
    }

    public Iterator<Header> getHeaders(String string, String string2) {
        return this.getHeaders(string, string2, true);
    }

    @Override
    @NotNull
    public Iterator<Header> getHeaders(final @NotNull String string, final @NotNull String string2, final boolean bl) {
        return new Iterator<Header>(){
            int idx = 0;
            Header next;

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    this.fetch();
                }
                return this.next != null;
            }

            @Override
            public Header next() {
                if (this.next == null) {
                    this.fetch();
                    if (this.next == null) {
                        throw new NoSuchElementException();
                    }
                }
                if (bl) {
                    assert (HeaderList.this.get(this.idx - 1) == this.next);
                    HeaderList.this.understood(this.idx - 1);
                }
                Header header = this.next;
                this.next = null;
                return header;
            }

            private void fetch() {
                while (this.idx < HeaderList.this.size()) {
                    Header header;
                    if (!(header = HeaderList.this.get(this.idx++)).getLocalPart().equals(string2) || !header.getNamespaceURI().equals(string)) continue;
                    this.next = header;
                    break;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    @NotNull
    public Iterator<Header> getHeaders(@NotNull QName qName, boolean bl) {
        return this.getHeaders(qName.getNamespaceURI(), qName.getLocalPart(), bl);
    }

    @NotNull
    public Iterator<Header> getHeaders(@NotNull String string) {
        return this.getHeaders(string, true);
    }

    @Override
    @NotNull
    public Iterator<Header> getHeaders(final @NotNull String string, final boolean bl) {
        return new Iterator<Header>(){
            int idx = 0;
            Header next;

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    this.fetch();
                }
                return this.next != null;
            }

            @Override
            public Header next() {
                if (this.next == null) {
                    this.fetch();
                    if (this.next == null) {
                        throw new NoSuchElementException();
                    }
                }
                if (bl) {
                    assert (HeaderList.this.get(this.idx - 1) == this.next);
                    HeaderList.this.understood(this.idx - 1);
                }
                Header header = this.next;
                this.next = null;
                return header;
            }

            private void fetch() {
                while (this.idx < HeaderList.this.size()) {
                    Header header;
                    if (!(header = HeaderList.this.get(this.idx++)).getNamespaceURI().equals(string)) continue;
                    this.next = header;
                    break;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String getTo(AddressingVersion addressingVersion, SOAPVersion sOAPVersion) {
        return AddressingUtils.getTo(this, addressingVersion, sOAPVersion);
    }

    public String getAction(@NotNull AddressingVersion addressingVersion, @NotNull SOAPVersion sOAPVersion) {
        return AddressingUtils.getAction(this, addressingVersion, sOAPVersion);
    }

    public WSEndpointReference getReplyTo(@NotNull AddressingVersion addressingVersion, @NotNull SOAPVersion sOAPVersion) {
        return AddressingUtils.getReplyTo(this, addressingVersion, sOAPVersion);
    }

    public WSEndpointReference getFaultTo(@NotNull AddressingVersion addressingVersion, @NotNull SOAPVersion sOAPVersion) {
        return AddressingUtils.getFaultTo(this, addressingVersion, sOAPVersion);
    }

    public String getMessageID(@NotNull AddressingVersion addressingVersion, @NotNull SOAPVersion sOAPVersion) {
        return AddressingUtils.getMessageID(this, addressingVersion, sOAPVersion);
    }

    public String getRelatesTo(@NotNull AddressingVersion addressingVersion, @NotNull SOAPVersion sOAPVersion) {
        return AddressingUtils.getRelatesTo(this, addressingVersion, sOAPVersion);
    }

    public void fillRequestAddressingHeaders(Packet packet, AddressingVersion addressingVersion, SOAPVersion sOAPVersion, boolean bl, String string, boolean bl2) {
        AddressingUtils.fillRequestAddressingHeaders((MessageHeaders)this, packet, addressingVersion, sOAPVersion, bl, string, bl2);
    }

    public void fillRequestAddressingHeaders(Packet packet, AddressingVersion addressingVersion, SOAPVersion sOAPVersion, boolean bl, String string) {
        AddressingUtils.fillRequestAddressingHeaders(this, packet, addressingVersion, sOAPVersion, bl, string);
    }

    public void fillRequestAddressingHeaders(WSDLPort wSDLPort, @NotNull WSBinding wSBinding, Packet packet) {
        AddressingUtils.fillRequestAddressingHeaders(this, wSDLPort, wSBinding, packet);
    }

    @Override
    public boolean add(Header header) {
        return super.add(header);
    }

    @Override
    @Nullable
    public Header remove(@NotNull String string, @NotNull String string2) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            Header header = this.get(i);
            if (!header.getLocalPart().equals(string2) || !header.getNamespaceURI().equals(string)) continue;
            return this.remove(i);
        }
        return null;
    }

    @Override
    public boolean addOrReplace(Header header) {
        for (int i = 0; i < this.size(); ++i) {
            Header header2 = this.get(i);
            if (!header2.getNamespaceURI().equals(header.getNamespaceURI()) || !header2.getLocalPart().equals(header.getLocalPart())) continue;
            this.removeInternal(i);
            this.addInternal(i, header);
            return true;
        }
        return this.add(header);
    }

    @Override
    public void replace(Header header, Header header2) {
        for (int i = 0; i < this.size(); ++i) {
            Header header3 = this.get(i);
            if (!header3.getNamespaceURI().equals(header2.getNamespaceURI()) || !header3.getLocalPart().equals(header2.getLocalPart())) continue;
            this.removeInternal(i);
            this.addInternal(i, header2);
            return;
        }
        throw new IllegalArgumentException();
    }

    protected void addInternal(int n, Header header) {
        super.add(n, header);
    }

    protected Header removeInternal(int n) {
        return (Header)super.remove(n);
    }

    @Override
    @Nullable
    public Header remove(@NotNull QName qName) {
        return this.remove(qName.getNamespaceURI(), qName.getLocalPart());
    }

    @Override
    public Header remove(int n) {
        this.removeUnderstoodBit(n);
        return (Header)super.remove(n);
    }

    private void removeUnderstoodBit(int n) {
        assert (n < this.size());
        if (n < 32) {
            int n2 = this.understoodBits >>> -31 + n << n;
            int n3 = this.understoodBits << -n >>> 31 - n >>> 1;
            this.understoodBits = n2 | n3;
            if (this.moreUnderstoodBits != null && this.moreUnderstoodBits.cardinality() > 0) {
                if (this.moreUnderstoodBits.get(0)) {
                    this.understoodBits |= Integer.MIN_VALUE;
                }
                this.moreUnderstoodBits.clear(0);
                int n4 = this.moreUnderstoodBits.nextSetBit(1);
                while (n4 > 0) {
                    this.moreUnderstoodBits.set(n4 - 1);
                    this.moreUnderstoodBits.clear(n4);
                    n4 = this.moreUnderstoodBits.nextSetBit(n4 + 1);
                }
            }
        } else if (this.moreUnderstoodBits != null && this.moreUnderstoodBits.cardinality() > 0) {
            this.moreUnderstoodBits.clear(n -= 32);
            int n5 = this.moreUnderstoodBits.nextSetBit(n);
            while (n5 >= 1) {
                this.moreUnderstoodBits.set(n5 - 1);
                this.moreUnderstoodBits.clear(n5);
                n5 = this.moreUnderstoodBits.nextSetBit(n5 + 1);
            }
        }
        if (this.size() - 1 <= 33 && this.moreUnderstoodBits != null) {
            this.moreUnderstoodBits = null;
        }
    }

    @Override
    public boolean remove(Object object) {
        if (object != null) {
            for (int i = 0; i < this.size(); ++i) {
                if (!object.equals(this.get(i))) continue;
                this.remove(i);
                return true;
            }
        }
        return false;
    }

    public Header remove(Header header) {
        if (this.remove((Object)header)) {
            return header;
        }
        return null;
    }

    public static HeaderList copy(MessageHeaders messageHeaders) {
        if (messageHeaders == null) {
            return null;
        }
        return new HeaderList(messageHeaders);
    }

    public static HeaderList copy(HeaderList headerList) {
        return HeaderList.copy((MessageHeaders)headerList);
    }

    public void readResponseAddressingHeaders(WSDLPort wSDLPort, WSBinding wSBinding) {
    }

    @Override
    public void understood(QName qName) {
        this.get(qName, true);
    }

    @Override
    public void understood(String string, String string2) {
        this.get(string, string2, true);
    }

    @Override
    public Set<QName> getUnderstoodHeaders() {
        HashSet<QName> hashSet = new HashSet<QName>();
        for (int i = 0; i < this.size(); ++i) {
            if (!this.isUnderstood(i)) continue;
            Header header = this.get(i);
            hashSet.add(new QName(header.getNamespaceURI(), header.getLocalPart()));
        }
        return hashSet;
    }

    @Override
    public boolean isUnderstood(Header header) {
        return this.isUnderstood(header.getNamespaceURI(), header.getLocalPart());
    }

    @Override
    public boolean isUnderstood(String string, String string2) {
        for (int i = 0; i < this.size(); ++i) {
            Header header = this.get(i);
            if (!header.getLocalPart().equals(string2) || !header.getNamespaceURI().equals(string)) continue;
            return this.isUnderstood(i);
        }
        return false;
    }

    @Override
    public boolean isUnderstood(QName qName) {
        return this.isUnderstood(qName.getNamespaceURI(), qName.getLocalPart());
    }

    @Override
    public Set<QName> getNotUnderstoodHeaders(Set<String> set, Set<QName> set2, WSBinding wSBinding) {
        HashSet<QName> hashSet = null;
        if (set == null) {
            set = new HashSet<String>();
        }
        SOAPVersion sOAPVersion = this.getEffectiveSOAPVersion(wSBinding);
        set.add(sOAPVersion.implicitRole);
        for (int i = 0; i < this.size(); ++i) {
            Header header;
            if (this.isUnderstood(i) || (header = this.get(i)).isIgnorable(sOAPVersion, set)) continue;
            QName qName = new QName(header.getNamespaceURI(), header.getLocalPart());
            if (wSBinding == null) {
                if (hashSet == null) {
                    hashSet = new HashSet<QName>();
                }
                hashSet.add(qName);
                continue;
            }
            if (!(wSBinding instanceof SOAPBindingImpl) || ((SOAPBindingImpl)wSBinding).understandsHeader(qName) || set2.contains(qName)) continue;
            if (hashSet == null) {
                hashSet = new HashSet();
            }
            hashSet.add(qName);
        }
        return hashSet;
    }

    private SOAPVersion getEffectiveSOAPVersion(WSBinding wSBinding) {
        SOAPVersion sOAPVersion;
        SOAPVersion sOAPVersion2 = sOAPVersion = this.soapVersion != null ? this.soapVersion : wSBinding.getSOAPVersion();
        if (sOAPVersion == null) {
            sOAPVersion = SOAPVersion.SOAP_11;
        }
        return sOAPVersion;
    }

    public void setSoapVersion(SOAPVersion sOAPVersion) {
        this.soapVersion = sOAPVersion;
    }

    @Override
    public Iterator<Header> getHeaders() {
        return this.iterator();
    }

    @Override
    public List<Header> asList() {
        return this;
    }
}

