/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.io.InvalidClassException;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.net.SocketPermission;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.rmi.dgc.DGC;
import java.rmi.dgc.Lease;
import java.rmi.dgc.VMID;
import java.rmi.server.ObjID;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sun.misc.GC;
import sun.rmi.runtime.Log;
import sun.rmi.runtime.NewThreadAction;
import sun.rmi.server.UnicastRef;
import sun.rmi.server.Util;
import sun.rmi.transport.DGCImpl;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.LiveRef;
import sun.rmi.transport.Transport;
import sun.security.action.GetLongAction;

final class DGCClient {
    private static long nextSequenceNum = Long.MIN_VALUE;
    private static VMID vmid = new VMID();
    private static final long leaseValue = AccessController.doPrivileged(new GetLongAction("java.rmi.dgc.leaseValue", 600000L));
    private static final long cleanInterval = AccessController.doPrivileged(new GetLongAction("sun.rmi.dgc.cleanInterval", 180000L));
    private static final long gcInterval = AccessController.doPrivileged(new GetLongAction("sun.rmi.dgc.client.gcInterval", 3600000L));
    private static final int dirtyFailureRetries = 5;
    private static final int cleanFailureRetries = 5;
    private static final ObjID[] emptyObjIDArray = new ObjID[0];
    private static final ObjID dgcID = new ObjID(2);
    private static final AccessControlContext SOCKET_ACC;

    private DGCClient() {
    }

    static void registerRefs(Endpoint endpoint, List<LiveRef> list) {
        EndpointEntry endpointEntry;
        while (!(endpointEntry = EndpointEntry.lookup(endpoint)).registerRefs(list)) {
        }
    }

    private static synchronized long getNextSequenceNum() {
        return nextSequenceNum++;
    }

    private static long computeRenewTime(long l, long l2) {
        return l + l2 / 2L;
    }

    static {
        Permissions permissions = new Permissions();
        permissions.add(new SocketPermission("*", "connect,resolve"));
        ProtectionDomain[] protectionDomainArray = new ProtectionDomain[]{new ProtectionDomain(null, permissions)};
        SOCKET_ACC = new AccessControlContext(protectionDomainArray);
    }

    private static class EndpointEntry {
        private Endpoint endpoint;
        private DGC dgc;
        private Map<LiveRef, RefEntry> refTable = new HashMap<LiveRef, RefEntry>(5);
        private Set<RefEntry> invalidRefs = new HashSet<RefEntry>(5);
        private boolean removed = false;
        private long renewTime = Long.MAX_VALUE;
        private long expirationTime = Long.MIN_VALUE;
        private int dirtyFailures = 0;
        private long dirtyFailureStartTime;
        private long dirtyFailureDuration;
        private Thread renewCleanThread;
        private boolean interruptible = false;
        private ReferenceQueue<LiveRef> refQueue = new ReferenceQueue();
        private Set<CleanRequest> pendingCleans = new HashSet<CleanRequest>(5);
        private static Map<Endpoint, EndpointEntry> endpointTable = new HashMap<Endpoint, EndpointEntry>(5);
        private static GC.LatencyRequest gcLatencyRequest = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static EndpointEntry lookup(Endpoint endpoint) {
            Map<Endpoint, EndpointEntry> map = endpointTable;
            synchronized (map) {
                EndpointEntry endpointEntry = endpointTable.get(endpoint);
                if (endpointEntry == null) {
                    endpointEntry = new EndpointEntry(endpoint);
                    endpointTable.put(endpoint, endpointEntry);
                    if (gcLatencyRequest == null) {
                        gcLatencyRequest = GC.requestLatency(gcInterval);
                    }
                }
                return endpointEntry;
            }
        }

        private EndpointEntry(Endpoint endpoint) {
            this.endpoint = endpoint;
            try {
                LiveRef liveRef = new LiveRef(dgcID, endpoint, false);
                this.dgc = (DGC)Util.createProxy(DGCImpl.class, new UnicastRef(liveRef), true);
            }
            catch (RemoteException remoteException) {
                throw new Error("internal error creating DGC stub");
            }
            this.renewCleanThread = AccessController.doPrivileged(new NewThreadAction(new RenewCleanThread(), "RenewClean-" + endpoint, true));
            this.renewCleanThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean registerRefs(List<LiveRef> list) {
            long l;
            assert (!Thread.holdsLock(this));
            HashSet<RefEntry> hashSet = null;
            EndpointEntry endpointEntry = this;
            synchronized (endpointEntry) {
                if (this.removed) {
                    return false;
                }
                for (LiveRef liveRef : list) {
                    assert (liveRef.getEndpoint().equals(this.endpoint));
                    RefEntry refEntry = this.refTable.get(liveRef);
                    if (refEntry == null) {
                        LiveRef liveRef2 = (LiveRef)liveRef.clone();
                        refEntry = new RefEntry(liveRef2);
                        this.refTable.put(liveRef2, refEntry);
                        if (hashSet == null) {
                            hashSet = new HashSet<RefEntry>(5);
                        }
                        hashSet.add(refEntry);
                    }
                    refEntry.addInstanceToRefSet(liveRef);
                }
                if (hashSet == null) {
                    return true;
                }
                hashSet.addAll(this.invalidRefs);
                this.invalidRefs.clear();
                l = DGCClient.getNextSequenceNum();
            }
            this.makeDirtyCall((Set<RefEntry>)hashSet, l);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeRefEntry(RefEntry refEntry) {
            assert (Thread.holdsLock(this));
            assert (!this.removed);
            assert (this.refTable.containsKey(refEntry.getRef()));
            this.refTable.remove(refEntry.getRef());
            this.invalidRefs.remove(refEntry);
            if (this.refTable.isEmpty()) {
                Map<Endpoint, EndpointEntry> map = endpointTable;
                synchronized (map) {
                    endpointTable.remove(this.endpoint);
                    Transport transport = this.endpoint.getOutboundTransport();
                    transport.free(this.endpoint);
                    if (endpointTable.isEmpty()) {
                        assert (gcLatencyRequest != null);
                        gcLatencyRequest.cancel();
                        gcLatencyRequest = null;
                    }
                    this.removed = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void makeDirtyCall(Set<RefEntry> set, long l) {
            assert (!Thread.holdsLock(this));
            ObjID[] objIDArray = set != null ? EndpointEntry.createObjIDArray(set) : emptyObjIDArray;
            long l2 = System.currentTimeMillis();
            try {
                Lease lease = this.dgc.dirty(objIDArray, l, new Lease(vmid, leaseValue));
                long l3 = lease.getValue();
                long l4 = DGCClient.computeRenewTime(l2, l3);
                long l5 = l2 + l3;
                EndpointEntry endpointEntry = this;
                synchronized (endpointEntry) {
                    this.dirtyFailures = 0;
                    this.setRenewTime(l4);
                    this.expirationTime = l5;
                }
            }
            catch (Exception exception) {
                long l6 = System.currentTimeMillis();
                EndpointEntry endpointEntry = this;
                synchronized (endpointEntry) {
                    ++this.dirtyFailures;
                    if (exception instanceof UnmarshalException && exception.getCause() instanceof InvalidClassException) {
                        DGCImpl.dgcLog.log(Log.BRIEF, "InvalidClassException exception in DGC dirty call", exception);
                        return;
                    }
                    if (this.dirtyFailures == 1) {
                        this.dirtyFailureStartTime = l2;
                        this.dirtyFailureDuration = l6 - l2;
                        this.setRenewTime(l6);
                    } else {
                        long l7;
                        int n = this.dirtyFailures - 2;
                        if (n == 0) {
                            this.dirtyFailureDuration = Math.max(this.dirtyFailureDuration + (l6 - l2) >> 1, 1000L);
                        }
                        if ((l7 = l6 + (this.dirtyFailureDuration << n)) < this.expirationTime || this.dirtyFailures < 5 || l7 < this.dirtyFailureStartTime + leaseValue) {
                            this.setRenewTime(l7);
                        } else {
                            this.setRenewTime(Long.MAX_VALUE);
                        }
                    }
                    if (set != null) {
                        this.invalidRefs.addAll(set);
                        for (RefEntry refEntry : set) {
                            refEntry.markDirtyFailed();
                        }
                    }
                    if (this.renewTime >= this.expirationTime) {
                        this.invalidRefs.addAll(this.refTable.values());
                    }
                }
            }
        }

        private void setRenewTime(long l) {
            assert (Thread.holdsLock(this));
            if (l < this.renewTime) {
                this.renewTime = l;
                if (this.interruptible) {
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            renewCleanThread.interrupt();
                            return null;
                        }
                    });
                }
            } else {
                this.renewTime = l;
            }
        }

        private void processPhantomRefs(RefEntry.PhantomLiveRef phantomLiveRef) {
            assert (Thread.holdsLock(this));
            HashSet<RefEntry> hashSet = null;
            HashSet<RefEntry> hashSet2 = null;
            do {
                RefEntry refEntry = phantomLiveRef.getRefEntry();
                refEntry.removeInstanceFromRefSet(phantomLiveRef);
                if (!refEntry.isRefSetEmpty()) continue;
                if (refEntry.hasDirtyFailed()) {
                    if (hashSet == null) {
                        hashSet = new HashSet<RefEntry>(5);
                    }
                    hashSet.add(refEntry);
                } else {
                    if (hashSet2 == null) {
                        hashSet2 = new HashSet<RefEntry>(5);
                    }
                    hashSet2.add(refEntry);
                }
                this.removeRefEntry(refEntry);
            } while ((phantomLiveRef = (RefEntry.PhantomLiveRef)this.refQueue.poll()) != null);
            if (hashSet != null) {
                this.pendingCleans.add(new CleanRequest(EndpointEntry.createObjIDArray(hashSet), DGCClient.getNextSequenceNum(), true));
            }
            if (hashSet2 != null) {
                this.pendingCleans.add(new CleanRequest(EndpointEntry.createObjIDArray(hashSet2), DGCClient.getNextSequenceNum(), false));
            }
        }

        private void makeCleanCalls() {
            assert (!Thread.holdsLock(this));
            Iterator<CleanRequest> iterator = this.pendingCleans.iterator();
            while (iterator.hasNext()) {
                CleanRequest cleanRequest = iterator.next();
                try {
                    this.dgc.clean(cleanRequest.objIDs, cleanRequest.sequenceNum, vmid, cleanRequest.strong);
                    iterator.remove();
                }
                catch (Exception exception) {
                    if (++cleanRequest.failures < 5) continue;
                    iterator.remove();
                }
            }
        }

        private static ObjID[] createObjIDArray(Set<RefEntry> set) {
            ObjID[] objIDArray = new ObjID[set.size()];
            Iterator<RefEntry> iterator = set.iterator();
            for (int i = 0; i < objIDArray.length; ++i) {
                objIDArray[i] = iterator.next().getRef().getObjID();
            }
            return objIDArray;
        }

        private static class CleanRequest {
            final ObjID[] objIDs;
            final long sequenceNum;
            final boolean strong;
            int failures = 0;

            CleanRequest(ObjID[] objIDArray, long l, boolean bl) {
                this.objIDs = objIDArray;
                this.sequenceNum = l;
                this.strong = bl;
            }
        }

        private class RefEntry {
            private LiveRef ref;
            private Set<PhantomLiveRef> refSet = new HashSet<PhantomLiveRef>(5);
            private boolean dirtyFailed = false;

            public RefEntry(LiveRef liveRef) {
                this.ref = liveRef;
            }

            public LiveRef getRef() {
                return this.ref;
            }

            public void addInstanceToRefSet(LiveRef liveRef) {
                assert (Thread.holdsLock(EndpointEntry.this));
                assert (liveRef.equals(this.ref));
                this.refSet.add(new PhantomLiveRef(liveRef));
            }

            public void removeInstanceFromRefSet(PhantomLiveRef phantomLiveRef) {
                assert (Thread.holdsLock(EndpointEntry.this));
                assert (this.refSet.contains(phantomLiveRef));
                this.refSet.remove(phantomLiveRef);
            }

            public boolean isRefSetEmpty() {
                assert (Thread.holdsLock(EndpointEntry.this));
                return this.refSet.size() == 0;
            }

            public void markDirtyFailed() {
                assert (Thread.holdsLock(EndpointEntry.this));
                this.dirtyFailed = true;
            }

            public boolean hasDirtyFailed() {
                assert (Thread.holdsLock(EndpointEntry.this));
                return this.dirtyFailed;
            }

            private class PhantomLiveRef
            extends PhantomReference<LiveRef> {
                public PhantomLiveRef(LiveRef liveRef) {
                    super(liveRef, EndpointEntry.this.refQueue);
                }

                public RefEntry getRefEntry() {
                    return RefEntry.this;
                }
            }
        }

        private class RenewCleanThread
        implements Runnable {
            private RenewCleanThread() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                do {
                    long l;
                    long l2;
                    RefEntry.PhantomLiveRef phantomLiveRef = null;
                    boolean bl = false;
                    Set set = null;
                    long l3 = Long.MIN_VALUE;
                    EndpointEntry endpointEntry = EndpointEntry.this;
                    synchronized (endpointEntry) {
                        l2 = EndpointEntry.this.renewTime - System.currentTimeMillis();
                        l = Math.max(l2, 1L);
                        if (!EndpointEntry.this.pendingCleans.isEmpty()) {
                            l = Math.min(l, cleanInterval);
                        }
                        EndpointEntry.this.interruptible = true;
                    }
                    try {
                        phantomLiveRef = (RefEntry.PhantomLiveRef)EndpointEntry.this.refQueue.remove(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    endpointEntry = EndpointEntry.this;
                    synchronized (endpointEntry) {
                        EndpointEntry.this.interruptible = false;
                        Thread.interrupted();
                        if (phantomLiveRef != null) {
                            EndpointEntry.this.processPhantomRefs(phantomLiveRef);
                        }
                        if ((l2 = System.currentTimeMillis()) > EndpointEntry.this.renewTime) {
                            bl = true;
                            if (!EndpointEntry.this.invalidRefs.isEmpty()) {
                                set = EndpointEntry.this.invalidRefs;
                                EndpointEntry.this.invalidRefs = new HashSet(5);
                            }
                            l3 = DGCClient.getNextSequenceNum();
                        }
                    }
                    final boolean bl2 = bl;
                    final Set set2 = set;
                    final long l4 = l3;
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            if (bl2) {
                                EndpointEntry.this.makeDirtyCall(set2, l4);
                            }
                            if (!EndpointEntry.this.pendingCleans.isEmpty()) {
                                EndpointEntry.this.makeCleanCalls();
                            }
                            return null;
                        }
                    }, SOCKET_ACC);
                } while (!EndpointEntry.this.removed || !EndpointEntry.this.pendingCleans.isEmpty());
            }
        }
    }
}

