/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.saa;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.charset.MalformedInputException;
import java.util.Locale;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import oracle.forms.engine.Version;
import oracle.forms.registry.MessageGenerator;
import oracle.forms.saa.FormsAppletIntegration;
import oracle.forms.saa.FormsAppletStub;

public class FormsStandAloneApp
implements Runnable {
    private static final String STANDALONEAPP = "standaloneapp";
    private static final String SERVER_URL = "-url";
    private static final String TIMEOUT = "-t";
    private static final String JAVA_CODEBASE = "CODEBASE";
    private static final String JAVA_ARCHIVE = "ARCHIVE";
    private static final String FORMSSAL = "frmsal";
    private static final String DOCBASE = "DOCUMENTBASE";
    private static final String STANDALONEAPPVER = "standaloneappver";
    private URL mServerURL = null;
    private String mTarget = "";
    private int mTimeout = 60000;
    private TreeMap<String, String> mAppletParams = null;
    private String[] mArgs;
    protected final MessageGenerator mEMG = new MessageGenerator("oracle.forms.engine.ErrorMessageBundle", Locale.getDefault());

    public FormsStandAloneApp() {
    }

    public FormsStandAloneApp(String[] stringArray) {
        this.mArgs = stringArray;
    }

    private void printUsage() {
        System.out.println(this.mEMG.getText("FRM-92893"));
        System.out.println(this.mEMG.getText("FRM-92892", new Object[]{Version.getString()}));
        System.out.println(this.mEMG.getText("FRM-92890", new Object[]{FORMSSAL}));
    }

    private void setBaseTarget() {
        if (this.mServerURL != null) {
            int n = this.mServerURL.getPort();
            if (n == -1) {
                n = this.mServerURL.getDefaultPort();
            }
            this.mTarget = this.mServerURL.getProtocol() + "://" + this.mServerURL.getHost();
            if (n != -1) {
                this.mTarget = this.mTarget + ":" + n;
            }
        }
    }

    private String getArchiveURL(String string, String string2) {
        if (string2.startsWith("http:") || string2.startsWith("https:")) {
            return string2;
        }
        if (string2.startsWith("/")) {
            return this.mTarget + string2;
        }
        return this.mTarget + string + "/" + string2;
    }

    private String createSubDir(String string) {
        String string2 = string.endsWith(File.separator) ? "" : File.separator;
        String string3 = string.concat(string2 + FORMSSAL + File.separator + this.mServerURL.getHost() + File.separator + Version.getString());
        File file = new File(string3);
        if (!file.exists() && !file.mkdirs()) {
            string3 = string;
        }
        return string3;
    }

    private String getArchiveDirLocation() {
        String string = System.getProperty("java.io.tmpdir");
        string = string != null && !string.isEmpty() ? this.createSubDir(string) : ((string = System.getProperty("user.home")) != null && !string.isEmpty() ? this.createSubDir(string) : ".");
        return string;
    }

    private boolean processCmdLineParameters() {
        int n = this.mArgs.length;
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            String string;
            String string2 = this.mArgs[n2].trim();
            if (++n2 < n) {
                string = this.mArgs[n2].trim();
                ++n2;
            } else {
                return false;
            }
            if (string2.equalsIgnoreCase(SERVER_URL)) {
                if (string.startsWith("http")) {
                    try {
                        this.mServerURL = new URL(string);
                        String string3 = this.mServerURL.getQuery();
                        string3 = string3 != null && !string3.isEmpty() ? "&" : "?";
                        string3 = string3.concat("standaloneapp=true");
                        string3 = string3.concat("&standaloneappver=" + Version.getString());
                        this.mServerURL = new URL(string + string3);
                        this.setBaseTarget();
                        bl = true;
                        continue;
                    }
                    catch (MalformedURLException malformedURLException) {
                        System.out.println(malformedURLException.getMessage());
                        return false;
                    }
                }
                return false;
            }
            if (!string2.equalsIgnoreCase(TIMEOUT)) continue;
            try {
                this.mTimeout = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println(this.mEMG.getMessage("FRM-92494", new Object[]{this.mTimeout}));
            }
        }
        return bl;
    }

    private boolean getAppletParamsFromServer() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String[] stringArray;
            String string;
            Object object;
            Object object2;
            URLConnection uRLConnection = this.mServerURL.openConnection();
            uRLConnection.setRequestProperty("Accept", "text/*");
            uRLConnection.setRequestProperty("Accept-Encoding", "gzip");
            uRLConnection.setConnectTimeout(this.mTimeout);
            uRLConnection.setReadTimeout(this.mTimeout);
            uRLConnection.connect();
            InputStream inputStream = uRLConnection.getInputStream();
            if ("gzip".equalsIgnoreCase(uRLConnection.getContentEncoding())) {
                inputStream = new GZIPInputStream(inputStream, 4096);
            }
            String string2 = "ISO-8859-1";
            String string3 = uRLConnection.getContentType();
            if (string3 != null && ((String[])(object2 = string3.split(";"))).length == 2 && ((String[])(object = (string = object2[1]).split("="))).length == 2 && object[0].trim().equalsIgnoreCase("charset")) {
                string2 = ((String)object[1]).trim();
            }
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string2);
            object2 = new BufferedReader(inputStreamReader, 8192);
            this.mAppletParams = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            string = System.getProperty("line.separator");
            object = ((BufferedReader)object2).readLine();
            while (object != null) {
                if (!((String)(object = ((String)object).trim())).startsWith("#") && (stringArray = ((String)object).split("=", 2)).length == 2) {
                    this.mAppletParams.put(stringArray[0].trim(), stringArray[1].trim());
                }
                stringBuilder.append((String)object);
                stringBuilder.append(string);
                object = ((BufferedReader)object2).readLine();
            }
            if (this.mAppletParams.size() != 0) {
                stringArray = this.mAppletParams.get(DOCBASE);
                if (stringArray == null || stringArray.equals("")) {
                    this.mAppletParams.put(DOCBASE, this.mServerURL.getFile().toString());
                }
                this.mAppletParams.put(STANDALONEAPP, "true");
                return true;
            }
            System.out.println(this.mEMG.getMessage("FRM-92492"));
            System.out.println(stringBuilder.toString());
            return false;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            System.out.println(socketTimeoutException.getMessage());
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println(malformedURLException.getMessage());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println(unsupportedEncodingException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
        return false;
    }

    private boolean getArchivesFromServer() {
        boolean bl = false;
        String string = this.mAppletParams.get(JAVA_CODEBASE);
        String string2 = this.mAppletParams.get(JAVA_ARCHIVE);
        String string3 = this.getArchiveDirLocation();
        System.out.println(this.mEMG.getText("FRM-92891", new Object[]{string3}));
        if (string != null && !string.isEmpty() && string2 != null && !string2.isEmpty()) {
            Method method;
            string = string.trim();
            String[] stringArray = string2.split(",");
            int n = stringArray.length;
            if (n == 0) {
                return bl;
            }
            try {
                method = this.getClass().getClassLoader().getClass().getDeclaredMethod("appendClassPath", URL.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.out.println(noSuchMethodException.getMessage());
                return bl;
            }
            for (int i = 0; i < n; ++i) {
                String string4 = stringArray[i].trim();
                try {
                    Object object;
                    String string5 = string4.substring(string4.lastIndexOf("/") + 1);
                    File file = new File(string3 + File.separator + string5);
                    long l = file.length();
                    long l2 = file.lastModified();
                    String string6 = this.getArchiveURL(string, string4);
                    URL uRL = new URL(string6);
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    httpURLConnection.setConnectTimeout(this.mTimeout);
                    httpURLConnection.setReadTimeout(this.mTimeout);
                    httpURLConnection.setRequestMethod("HEAD");
                    long l3 = httpURLConnection.getContentLength();
                    long l4 = httpURLConnection.getLastModified();
                    httpURLConnection.disconnect();
                    if (l4 > l2 || l3 != l) {
                        object = uRL.openConnection();
                        ((URLConnection)object).setConnectTimeout(this.mTimeout);
                        ((URLConnection)object).setReadTimeout(this.mTimeout);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(((URLConnection)object).getInputStream());
                        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                        int n2 = 0;
                        byte[] byArray = new byte[1024];
                        while ((n2 = bufferedInputStream.read(byArray, 0, 1024)) != -1) {
                            bufferedOutputStream.write(byArray, 0, n2);
                        }
                        bufferedOutputStream.flush();
                        bufferedOutputStream.close();
                        bufferedInputStream.close();
                    }
                    object = file.toURI().toURL();
                    method.invoke((Object)this.getClass().getClassLoader(), object);
                    bl = true;
                    continue;
                }
                catch (MalformedInputException malformedInputException) {
                    System.out.println(malformedInputException.getMessage());
                    bl = false;
                    break;
                }
                catch (IOException iOException) {
                    System.out.println(iOException.getMessage());
                    bl = false;
                    break;
                }
                catch (SecurityException securityException) {
                    System.out.println(securityException.getMessage());
                    bl = false;
                    break;
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.out.println(illegalAccessException.getMessage());
                    bl = false;
                    break;
                }
                catch (InvocationTargetException invocationTargetException) {
                    System.out.println(invocationTargetException.getMessage());
                    bl = false;
                    break;
                }
            }
        }
        if (bl) {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        }
        return bl;
    }

    public static void main(String[] stringArray) throws Exception {
        String[] stringArray2 = System.getProperty("java.class.path").split(File.pathSeparator);
        int n = stringArray2.length;
        URL[] uRLArray = new URL[n];
        while (n > 0) {
            uRLArray[--n] = new File(stringArray2[n]).toURI().toURL();
        }
        FormsURLClassLoader formsURLClassLoader = new FormsURLClassLoader(uRLArray, ClassLoader.getSystemClassLoader().getParent());
        Class<?> clazz = Class.forName("oracle.forms.saa.FormsStandAloneApp", true, formsURLClassLoader);
        clazz.getDeclaredMethod("run", stringArray.getClass()).invoke(clazz.newInstance(), new Object[]{stringArray});
    }

    public void run(String[] stringArray) {
        this.mArgs = stringArray;
        this.run();
    }

    @Override
    public void run() {
        if (!this.processCmdLineParameters()) {
            this.printUsage();
            return;
        }
        if (!this.getAppletParamsFromServer()) {
            System.out.println(this.mEMG.getMessage("FRM-92490"));
            return;
        }
        if (!this.getArchivesFromServer()) {
            System.out.println(this.mEMG.getMessage("FRM-92491"));
            return;
        }
        FormsAppletIntegration formsAppletIntegration = new FormsAppletIntegration(new FormsAppletStub(this.mTarget, this.mAppletParams));
        formsAppletIntegration.startApplet();
    }

    public static class FormsURLClassLoader
    extends URLClassLoader {
        public FormsURLClassLoader() {
            super(new URL[0]);
        }

        public FormsURLClassLoader(URL[] uRLArray) {
            super(uRLArray);
        }

        public FormsURLClassLoader(URL[] uRLArray, ClassLoader classLoader) {
            super(uRLArray, classLoader);
        }

        public void appendClassPath(URL uRL) {
            this.addURL(uRL);
        }
    }
}

