/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.saa;

import java.applet.AppletStub;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JPanel;
import oracle.forms.engine.Main;
import oracle.forms.registry.MessageGenerator;
import oracle.forms.saa.FormsAppletStub;

public class FormsAppletIntegration {
    private static final String WIDTH = "WIDTH";
    private static final String HEIGHT = "HEIGHT";
    private FormsAppletStub mFormsAppletStub = null;
    private Main mFormsApplet = null;

    FormsAppletIntegration(FormsAppletStub formsAppletStub) {
        this.mFormsAppletStub = formsAppletStub;
    }

    private int getAppletDimensionBySide(String string) {
        int n = -1;
        try {
            return Integer.parseInt(this.mFormsApplet.getParameter(string).trim());
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = this.mFormsApplet.getParameter(string).trim();
            if (string2.endsWith("%") && string2.length() > 1) {
                try {
                    double d;
                    double d2 = Double.parseDouble(string2.substring(0, string2.length() - 1));
                    if (d2 > 100.0) {
                        return n;
                    }
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    if (string.startsWith(WIDTH)) {
                        d = toolkit.getScreenSize().getWidth();
                    } else if (string.startsWith(HEIGHT)) {
                        d = toolkit.getScreenSize().getHeight();
                    } else {
                        return n;
                    }
                    d = d * d2 * 0.01;
                    return (int)d;
                }
                catch (NumberFormatException numberFormatException2) {
                    numberFormatException2.printStackTrace();
                    return n;
                }
            }
            numberFormatException.printStackTrace();
            return n;
        }
    }

    private int getAppletWidth() {
        return this.getAppletDimensionBySide(WIDTH);
    }

    private int getAppletHeight() {
        return this.getAppletDimensionBySide(HEIGHT);
    }

    private String getFrameTitle() {
        MessageGenerator messageGenerator = new MessageGenerator("oracle.forms.engine.RunformBundle", Locale.getDefault());
        return messageGenerator.getText("FRAMETITLE");
    }

    private void stopApplet() {
        this.mFormsAppletStub.setActive(false);
        this.mFormsApplet.stop();
        this.mFormsApplet.destroy();
        System.exit(0);
    }

    public void startApplet() {
        JFrame jFrame = new JFrame(this.getFrameTitle());
        JPanel jPanel = new JPanel();
        this.mFormsApplet = new Main();
        this.mFormsAppletStub.setActive(true);
        this.mFormsApplet.setStub((AppletStub)this.mFormsAppletStub);
        jPanel.add((Component)this.mFormsApplet);
        jFrame.getContentPane().add(jPanel);
        int n = this.getAppletWidth();
        int n2 = this.getAppletHeight();
        if (n < 0 || n2 < 0) {
            this.stopApplet();
            return;
        }
        jFrame.setSize(n, n2);
        jFrame.addNotify();
        this.mFormsApplet.init();
        this.mFormsApplet.start();
        jFrame.setVisible(false);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                FormsAppletIntegration.this.stopApplet();
            }
        });
    }
}

