/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.FileInputStream;
import java.security.AccessController;
import java.security.CryptoPrimitive;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import sun.security.action.GetPropertyAction;
import sun.security.ssl.AbstractKeyManagerWrapper;
import sun.security.ssl.AbstractTrustManagerWrapper;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.CipherSuiteList;
import sun.security.ssl.Debug;
import sun.security.ssl.DummyX509KeyManager;
import sun.security.ssl.DummyX509TrustManager;
import sun.security.ssl.EphemeralKeyManager;
import sun.security.ssl.JsseJce;
import sun.security.ssl.ProtocolList;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLAlgorithmConstraints;
import sun.security.ssl.SSLEngineImpl;
import sun.security.ssl.SSLServerSocketFactoryImpl;
import sun.security.ssl.SSLSessionContextImpl;
import sun.security.ssl.SSLSocketFactoryImpl;
import sun.security.ssl.SunJSSE;
import sun.security.ssl.SunX509KeyManagerImpl;
import sun.security.ssl.TrustManagerFactoryImpl;
import sun.security.ssl.X509KeyManagerImpl;
import sun.security.ssl.X509TrustManagerImpl;

public abstract class SSLContextImpl
extends SSLContextSpi {
    private static final Debug debug = Debug.getInstance("ssl");
    private final EphemeralKeyManager ephemeralKeyManager = new EphemeralKeyManager();
    private final SSLSessionContextImpl clientCache = new SSLSessionContextImpl();
    private final SSLSessionContextImpl serverCache = new SSLSessionContextImpl();
    private boolean isInitialized;
    private X509ExtendedKeyManager keyManager;
    private X509TrustManager trustManager;
    private SecureRandom secureRandom;
    private static final Collection<CipherSuite> clientCustomizedCipherSuites = SSLContextImpl.getCustomizedCipherSuites("jdk.tls.client.cipherSuites");
    private static final Collection<CipherSuite> serverCustomizedCipherSuites = SSLContextImpl.getCustomizedCipherSuites("jdk.tls.server.cipherSuites");

    SSLContextImpl() {
    }

    @Override
    protected void engineInit(KeyManager[] keyManagerArray, TrustManager[] trustManagerArray, SecureRandom secureRandom) throws KeyManagementException {
        this.isInitialized = false;
        this.keyManager = this.chooseKeyManager(keyManagerArray);
        if (trustManagerArray == null) {
            try {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init((KeyStore)null);
                trustManagerArray = trustManagerFactory.getTrustManagers();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.trustManager = this.chooseTrustManager(trustManagerArray);
        if (secureRandom == null) {
            this.secureRandom = JsseJce.getSecureRandom();
        } else {
            if (SunJSSE.isFIPS() && secureRandom.getProvider() != SunJSSE.cryptoProvider) {
                throw new KeyManagementException("FIPS mode: SecureRandom must be from provider " + SunJSSE.cryptoProvider.getName());
            }
            this.secureRandom = secureRandom;
        }
        if (debug != null && Debug.isOn("sslctx")) {
            System.out.println("trigger seeding of SecureRandom");
        }
        this.secureRandom.nextInt();
        if (debug != null && Debug.isOn("sslctx")) {
            System.out.println("done seeding SecureRandom");
        }
        this.isInitialized = true;
    }

    private X509TrustManager chooseTrustManager(TrustManager[] trustManagerArray) throws KeyManagementException {
        for (int i = 0; trustManagerArray != null && i < trustManagerArray.length; ++i) {
            if (!(trustManagerArray[i] instanceof X509TrustManager)) continue;
            if (SunJSSE.isFIPS() && !(trustManagerArray[i] instanceof X509TrustManagerImpl)) {
                throw new KeyManagementException("FIPS mode: only SunJSSE TrustManagers may be used");
            }
            if (trustManagerArray[i] instanceof X509ExtendedTrustManager) {
                return (X509TrustManager)trustManagerArray[i];
            }
            return new AbstractTrustManagerWrapper((X509TrustManager)trustManagerArray[i]);
        }
        return DummyX509TrustManager.INSTANCE;
    }

    private X509ExtendedKeyManager chooseKeyManager(KeyManager[] keyManagerArray) throws KeyManagementException {
        for (int i = 0; keyManagerArray != null && i < keyManagerArray.length; ++i) {
            KeyManager keyManager = keyManagerArray[i];
            if (!(keyManager instanceof X509KeyManager)) continue;
            if (SunJSSE.isFIPS()) {
                if (keyManager instanceof X509KeyManagerImpl || keyManager instanceof SunX509KeyManagerImpl) {
                    return (X509ExtendedKeyManager)keyManager;
                }
                throw new KeyManagementException("FIPS mode: only SunJSSE KeyManagers may be used");
            }
            if (keyManager instanceof X509ExtendedKeyManager) {
                return (X509ExtendedKeyManager)keyManager;
            }
            if (debug != null && Debug.isOn("sslctx")) {
                System.out.println("X509KeyManager passed to SSLContext.init():  need an X509ExtendedKeyManager for SSLEngine use");
            }
            return new AbstractKeyManagerWrapper((X509KeyManager)keyManager);
        }
        return DummyX509KeyManager.INSTANCE;
    }

    @Override
    protected SSLSocketFactory engineGetSocketFactory() {
        if (!this.isInitialized) {
            throw new IllegalStateException("SSLContextImpl is not initialized");
        }
        return new SSLSocketFactoryImpl(this);
    }

    @Override
    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        if (!this.isInitialized) {
            throw new IllegalStateException("SSLContext is not initialized");
        }
        return new SSLServerSocketFactoryImpl(this);
    }

    abstract SSLEngine createSSLEngineImpl();

    abstract SSLEngine createSSLEngineImpl(String var1, int var2);

    @Override
    protected SSLEngine engineCreateSSLEngine() {
        if (!this.isInitialized) {
            throw new IllegalStateException("SSLContextImpl is not initialized");
        }
        return this.createSSLEngineImpl();
    }

    @Override
    protected SSLEngine engineCreateSSLEngine(String string, int n) {
        if (!this.isInitialized) {
            throw new IllegalStateException("SSLContextImpl is not initialized");
        }
        return this.createSSLEngineImpl(string, n);
    }

    @Override
    protected SSLSessionContext engineGetClientSessionContext() {
        return this.clientCache;
    }

    @Override
    protected SSLSessionContext engineGetServerSessionContext() {
        return this.serverCache;
    }

    SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    X509ExtendedKeyManager getX509KeyManager() {
        return this.keyManager;
    }

    X509TrustManager getX509TrustManager() {
        return this.trustManager;
    }

    EphemeralKeyManager getEphemeralKeyManager() {
        return this.ephemeralKeyManager;
    }

    abstract ProtocolList getSuportedProtocolList();

    abstract ProtocolList getServerDefaultProtocolList();

    abstract ProtocolList getClientDefaultProtocolList();

    abstract CipherSuiteList getSupportedCipherSuiteList();

    abstract CipherSuiteList getServerDefaultCipherSuiteList();

    abstract CipherSuiteList getClientDefaultCipherSuiteList();

    ProtocolList getDefaultProtocolList(boolean bl) {
        return bl ? this.getServerDefaultProtocolList() : this.getClientDefaultProtocolList();
    }

    CipherSuiteList getDefaultCipherSuiteList(boolean bl) {
        return bl ? this.getServerDefaultCipherSuiteList() : this.getClientDefaultCipherSuiteList();
    }

    boolean isDefaultProtocolList(ProtocolList protocolList) {
        return protocolList == this.getServerDefaultProtocolList() || protocolList == this.getClientDefaultProtocolList();
    }

    boolean isDefaultCipherSuiteList(CipherSuiteList cipherSuiteList) {
        return cipherSuiteList == this.getServerDefaultCipherSuiteList() || cipherSuiteList == this.getClientDefaultCipherSuiteList();
    }

    private static CipherSuiteList getApplicableSupportedCipherSuiteList(ProtocolList protocolList) {
        return SSLContextImpl.getApplicableCipherSuiteList(CipherSuite.allowedCipherSuites(), protocolList, 1);
    }

    private static CipherSuiteList getApplicableEnabledCipherSuiteList(ProtocolList protocolList, boolean bl) {
        if (bl) {
            if (!clientCustomizedCipherSuites.isEmpty()) {
                return SSLContextImpl.getApplicableCipherSuiteList(clientCustomizedCipherSuites, protocolList, 1);
            }
        } else if (!serverCustomizedCipherSuites.isEmpty()) {
            return SSLContextImpl.getApplicableCipherSuiteList(serverCustomizedCipherSuites, protocolList, 1);
        }
        return SSLContextImpl.getApplicableCipherSuiteList(CipherSuite.allowedCipherSuites(), protocolList, 300);
    }

    private static CipherSuiteList getApplicableCipherSuiteList(Collection<CipherSuite> collection, ProtocolList protocolList, int n) {
        TreeSet<CipherSuite> treeSet = new TreeSet<CipherSuite>();
        if (!protocolList.collection().isEmpty() && protocolList.min.v != ProtocolVersion.NONE.v) {
            for (CipherSuite cipherSuite : collection) {
                if (!cipherSuite.allowed || cipherSuite.priority < n) continue;
                if (cipherSuite.isAvailable() && cipherSuite.obsoleted > protocolList.min.v && cipherSuite.supported <= protocolList.max.v) {
                    if (SSLAlgorithmConstraints.DEFAULT.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), cipherSuite.name, null)) {
                        treeSet.add(cipherSuite);
                        continue;
                    }
                    if (debug == null || !Debug.isOn("sslctx") || !Debug.isOn("verbose")) continue;
                    System.out.println("Ignoring disabled cipher suite: " + cipherSuite.name);
                    continue;
                }
                if (debug == null || !Debug.isOn("sslctx") || !Debug.isOn("verbose")) continue;
                if (cipherSuite.obsoleted <= protocolList.min.v) {
                    System.out.println("Ignoring obsoleted cipher suite: " + cipherSuite);
                    continue;
                }
                if (cipherSuite.supported > protocolList.max.v) {
                    System.out.println("Ignoring unsupported cipher suite: " + cipherSuite);
                    continue;
                }
                System.out.println("Ignoring unavailable cipher suite: " + cipherSuite);
            }
        }
        return new CipherSuiteList(treeSet);
    }

    private static Collection<CipherSuite> getCustomizedCipherSuites(String string) {
        String string2 = AccessController.doPrivileged(new GetPropertyAction(string));
        if (debug != null && Debug.isOn("sslctx")) {
            System.out.println("System property " + string + " is set to '" + string2 + "'");
        }
        if (string2 != null && string2.length() != 0 && string2.length() > 1 && string2.charAt(0) == '\"' && string2.charAt(string2.length() - 1) == '\"') {
            string2 = string2.substring(1, string2.length() - 1);
        }
        if (string2 != null && string2.length() != 0) {
            String[] stringArray = string2.split(",");
            ArrayList<CipherSuite> arrayList = new ArrayList<CipherSuite>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                CipherSuite cipherSuite;
                stringArray[i] = stringArray[i].trim();
                if (stringArray[i].isEmpty()) continue;
                try {
                    cipherSuite = CipherSuite.valueOf(stringArray[i]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (debug == null || !Debug.isOn("sslctx")) continue;
                    System.out.println("Unknown or unsupported cipher suite name: " + stringArray[i]);
                    continue;
                }
                if (cipherSuite.isAvailable()) {
                    arrayList.add(cipherSuite);
                    continue;
                }
                if (debug == null || !Debug.isOn("sslctx")) continue;
                System.out.println("The current installed providers do not support cipher suite: " + stringArray[i]);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    private static String[] getAvailableProtocols(ProtocolVersion[] protocolVersionArray) {
        List<String> list = Collections.emptyList();
        if (protocolVersionArray != null && protocolVersionArray.length != 0) {
            list = new ArrayList(protocolVersionArray.length);
            for (ProtocolVersion protocolVersion : protocolVersionArray) {
                if (!ProtocolVersion.availableProtocols.contains(protocolVersion)) continue;
                list.add(protocolVersion.name);
            }
        }
        return list.toArray(new String[0]);
    }

    private static abstract class AbstractTLSContext
    extends SSLContextImpl {
        private static final ProtocolList supportedProtocolList;
        private static final ProtocolList serverDefaultProtocolList;
        private static final CipherSuiteList supportedCipherSuiteList;
        private static final CipherSuiteList serverDefaultCipherSuiteList;

        private AbstractTLSContext() {
        }

        @Override
        ProtocolList getSuportedProtocolList() {
            return supportedProtocolList;
        }

        @Override
        CipherSuiteList getSupportedCipherSuiteList() {
            return supportedCipherSuiteList;
        }

        @Override
        ProtocolList getServerDefaultProtocolList() {
            return serverDefaultProtocolList;
        }

        @Override
        CipherSuiteList getServerDefaultCipherSuiteList() {
            return serverDefaultCipherSuiteList;
        }

        @Override
        SSLEngine createSSLEngineImpl() {
            return new SSLEngineImpl(this);
        }

        @Override
        SSLEngine createSSLEngineImpl(String string, int n) {
            return new SSLEngineImpl(this, string, n);
        }

        static {
            if (SunJSSE.isFIPS()) {
                supportedProtocolList = new ProtocolList(new String[]{ProtocolVersion.TLS10.name, ProtocolVersion.TLS11.name, ProtocolVersion.TLS12.name});
                serverDefaultProtocolList = new ProtocolList(SSLContextImpl.getAvailableProtocols(new ProtocolVersion[]{ProtocolVersion.TLS10, ProtocolVersion.TLS11, ProtocolVersion.TLS12}));
            } else {
                supportedProtocolList = new ProtocolList(new String[]{ProtocolVersion.SSL20Hello.name, ProtocolVersion.SSL30.name, ProtocolVersion.TLS10.name, ProtocolVersion.TLS11.name, ProtocolVersion.TLS12.name});
                serverDefaultProtocolList = new ProtocolList(SSLContextImpl.getAvailableProtocols(new ProtocolVersion[]{ProtocolVersion.SSL20Hello, ProtocolVersion.SSL30, ProtocolVersion.TLS10, ProtocolVersion.TLS11, ProtocolVersion.TLS12}));
            }
            supportedCipherSuiteList = SSLContextImpl.getApplicableSupportedCipherSuiteList(AbstractTLSContext.supportedProtocolList);
            serverDefaultCipherSuiteList = SSLContextImpl.getApplicableEnabledCipherSuiteList(AbstractTLSContext.serverDefaultProtocolList, false);
        }
    }

    private static class CustomizedSSLProtocols {
        private static final String PROPERTY_NAME = "jdk.tls.client.protocols";
        static IllegalArgumentException reservedException = null;
        static ArrayList<ProtocolVersion> customizedProtocols = new ArrayList();

        private CustomizedSSLProtocols() {
        }

        static {
            String string = AccessController.doPrivileged(new GetPropertyAction(PROPERTY_NAME));
            if (string != null && string.length() != 0 && string.length() > 1 && string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
                string = string.substring(1, string.length() - 1);
            }
            if (string != null && string.length() != 0) {
                String[] stringArray = string.split(",");
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = stringArray[i].trim();
                    try {
                        ProtocolVersion protocolVersion = ProtocolVersion.valueOf(stringArray[i]);
                        if (SunJSSE.isFIPS() && (protocolVersion.v == ProtocolVersion.SSL30.v || protocolVersion.v == ProtocolVersion.SSL20Hello.v)) {
                            reservedException = new IllegalArgumentException("jdk.tls.client.protocols: " + protocolVersion + " is not FIPS compliant");
                            break;
                        }
                        if (customizedProtocols.contains(protocolVersion)) continue;
                        customizedProtocols.add(protocolVersion);
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        reservedException = new IllegalArgumentException("jdk.tls.client.protocols: " + stringArray[i] + " is not a standard SSL protocol name", illegalArgumentException);
                    }
                }
            }
        }
    }

    private static class CustomizedTLSContext
    extends AbstractTLSContext {
        private static final ProtocolList clientDefaultProtocolList;
        private static final CipherSuiteList clientDefaultCipherSuiteList;
        private static IllegalArgumentException reservedException;

        protected CustomizedTLSContext() {
            if (reservedException != null) {
                throw reservedException;
            }
        }

        @Override
        ProtocolList getClientDefaultProtocolList() {
            return clientDefaultProtocolList;
        }

        @Override
        CipherSuiteList getClientDefaultCipherSuiteList() {
            return clientDefaultCipherSuiteList;
        }

        static {
            reservedException = null;
            reservedException = CustomizedSSLProtocols.reservedException;
            if (reservedException == null) {
                ProtocolVersion[] protocolVersionArray;
                ArrayList<ProtocolVersion> arrayList = new ArrayList<ProtocolVersion>();
                for (ProtocolVersion protocolVersion : CustomizedSSLProtocols.customizedProtocols) {
                    arrayList.add(protocolVersion);
                }
                if (arrayList.isEmpty()) {
                    protocolVersionArray = SunJSSE.isFIPS() ? new ProtocolVersion[]{ProtocolVersion.TLS10, ProtocolVersion.TLS11, ProtocolVersion.TLS12} : new ProtocolVersion[]{ProtocolVersion.SSL30, ProtocolVersion.TLS10, ProtocolVersion.TLS11, ProtocolVersion.TLS12};
                } else {
                    protocolVersionArray = new ProtocolVersion[arrayList.size()];
                    protocolVersionArray = arrayList.toArray(protocolVersionArray);
                }
                clientDefaultProtocolList = new ProtocolList(SSLContextImpl.getAvailableProtocols(protocolVersionArray));
                clientDefaultCipherSuiteList = SSLContextImpl.getApplicableEnabledCipherSuiteList(CustomizedTLSContext.clientDefaultProtocolList, true);
            } else {
                clientDefaultProtocolList = null;
                clientDefaultCipherSuiteList = null;
            }
        }
    }

    private static final class DefaultManagersHolder {
        private static final String NONE = "NONE";
        private static final String P11KEYSTORE = "PKCS11";
        private static final TrustManager[] trustManagers;
        private static final KeyManager[] keyManagers;
        static Exception reservedException;

        private DefaultManagersHolder() {
        }

        private static TrustManager[] getTrustManagers() throws Exception {
            KeyStore keyStore = TrustManagerFactoryImpl.getCacertsKeyStore("defaultctx");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            return trustManagerFactory.getTrustManagers();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static KeyManager[] getKeyManagers() throws Exception {
            Object object;
            final HashMap hashMap = new HashMap();
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    hashMap.put("keyStore", System.getProperty("javax.net.ssl.keyStore", ""));
                    hashMap.put("keyStoreType", System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType()));
                    hashMap.put("keyStoreProvider", System.getProperty("javax.net.ssl.keyStoreProvider", ""));
                    hashMap.put("keyStorePasswd", System.getProperty("javax.net.ssl.keyStorePassword", ""));
                    return null;
                }
            });
            final String string = (String)hashMap.get("keyStore");
            String string2 = (String)hashMap.get("keyStoreType");
            String string3 = (String)hashMap.get("keyStoreProvider");
            if (debug != null && Debug.isOn("defaultctx")) {
                System.out.println("keyStore is : " + string);
                System.out.println("keyStore type is : " + string2);
                System.out.println("keyStore provider is : " + string3);
            }
            if (P11KEYSTORE.equals(string2) && !NONE.equals(string)) {
                throw new IllegalArgumentException("if keyStoreType is PKCS11, then keyStore must be NONE");
            }
            FileInputStream fileInputStream = null;
            KeyStore keyStore = null;
            char[] cArray = null;
            try {
                if (string.length() != 0 && !NONE.equals(string)) {
                    fileInputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                        @Override
                        public FileInputStream run() throws Exception {
                            return new FileInputStream(string);
                        }
                    });
                }
                if (((String)(object = (String)hashMap.get("keyStorePasswd"))).length() != 0) {
                    cArray = ((String)object).toCharArray();
                }
                if (string2.length() != 0) {
                    if (debug != null && Debug.isOn("defaultctx")) {
                        System.out.println("init keystore");
                    }
                    keyStore = string3.length() == 0 ? KeyStore.getInstance(string2) : KeyStore.getInstance(string2, string3);
                    keyStore.load(fileInputStream, cArray);
                }
            }
            finally {
                if (fileInputStream != null) {
                    fileInputStream.close();
                    fileInputStream = null;
                }
            }
            if (debug != null && Debug.isOn("defaultctx")) {
                System.out.println("init keymanager of type " + KeyManagerFactory.getDefaultAlgorithm());
            }
            object = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            if (P11KEYSTORE.equals(string2)) {
                ((KeyManagerFactory)object).init(keyStore, null);
            } else {
                ((KeyManagerFactory)object).init(keyStore, cArray);
            }
            return ((KeyManagerFactory)object).getKeyManagers();
        }

        static {
            TrustManager[] trustManagerArray;
            reservedException = null;
            try {
                trustManagerArray = DefaultManagersHolder.getTrustManagers();
            }
            catch (Exception exception) {
                reservedException = exception;
                trustManagerArray = new TrustManager[]{};
            }
            trustManagers = trustManagerArray;
            if (reservedException == null) {
                KeyManager[] keyManagerArray;
                try {
                    keyManagerArray = DefaultManagersHolder.getKeyManagers();
                }
                catch (Exception exception) {
                    reservedException = exception;
                    keyManagerArray = new KeyManager[]{};
                }
                keyManagers = keyManagerArray;
            } else {
                keyManagers = new KeyManager[0];
            }
        }
    }

    public static final class DefaultSSLContext
    extends CustomizedTLSContext {
        public DefaultSSLContext() throws Exception {
            if (DefaultManagersHolder.reservedException != null) {
                throw DefaultManagersHolder.reservedException;
            }
            try {
                super.engineInit(DefaultManagersHolder.keyManagers, DefaultManagersHolder.trustManagers, null);
            }
            catch (Exception exception) {
                if (debug != null && Debug.isOn("defaultctx")) {
                    System.out.println("default context init failed: " + exception);
                }
                throw exception;
            }
        }

        @Override
        protected void engineInit(KeyManager[] keyManagerArray, TrustManager[] trustManagerArray, SecureRandom secureRandom) throws KeyManagementException {
            throw new KeyManagementException("Default SSLContext is initialized automatically");
        }

        static SSLContextImpl getDefaultImpl() throws Exception {
            if (DefaultSSLContextHolder.reservedException != null) {
                throw DefaultSSLContextHolder.reservedException;
            }
            return DefaultSSLContextHolder.sslContext;
        }
    }

    private static final class DefaultSSLContextHolder {
        private static final SSLContextImpl sslContext;
        static Exception reservedException;

        private DefaultSSLContextHolder() {
        }

        static {
            reservedException = null;
            DefaultSSLContext defaultSSLContext = null;
            if (DefaultManagersHolder.reservedException != null) {
                reservedException = DefaultManagersHolder.reservedException;
            } else {
                try {
                    defaultSSLContext = new DefaultSSLContext();
                }
                catch (Exception exception) {
                    reservedException = exception;
                }
            }
            sslContext = defaultSSLContext;
        }
    }

    public static final class TLS10Context
    extends AbstractTLSContext {
        private static final ProtocolList clientDefaultProtocolList = SunJSSE.isFIPS() ? new ProtocolList(SSLContextImpl.access$000(new ProtocolVersion[]{ProtocolVersion.TLS10})) : new ProtocolList(SSLContextImpl.access$000(new ProtocolVersion[]{ProtocolVersion.SSL30, ProtocolVersion.TLS10}));
        private static final CipherSuiteList clientDefaultCipherSuiteList = SSLContextImpl.access$200(clientDefaultProtocolList, true);

        @Override
        ProtocolList getClientDefaultProtocolList() {
            return clientDefaultProtocolList;
        }

        @Override
        CipherSuiteList getClientDefaultCipherSuiteList() {
            return clientDefaultCipherSuiteList;
        }
    }

    public static final class TLS11Context
    extends AbstractTLSContext {
        private static final ProtocolList clientDefaultProtocolList = SunJSSE.isFIPS() ? new ProtocolList(SSLContextImpl.access$000(new ProtocolVersion[]{ProtocolVersion.TLS10, ProtocolVersion.TLS11})) : new ProtocolList(SSLContextImpl.access$000(new ProtocolVersion[]{ProtocolVersion.SSL30, ProtocolVersion.TLS10, ProtocolVersion.TLS11}));
        private static final CipherSuiteList clientDefaultCipherSuiteList = SSLContextImpl.access$200(clientDefaultProtocolList, true);

        @Override
        ProtocolList getClientDefaultProtocolList() {
            return clientDefaultProtocolList;
        }

        @Override
        CipherSuiteList getClientDefaultCipherSuiteList() {
            return clientDefaultCipherSuiteList;
        }
    }

    public static final class TLS12Context
    extends AbstractTLSContext {
        private static final ProtocolList clientDefaultProtocolList = SunJSSE.isFIPS() ? new ProtocolList(SSLContextImpl.access$000(new ProtocolVersion[]{ProtocolVersion.TLS10, ProtocolVersion.TLS11, ProtocolVersion.TLS12})) : new ProtocolList(SSLContextImpl.access$000(new ProtocolVersion[]{ProtocolVersion.SSL30, ProtocolVersion.TLS10, ProtocolVersion.TLS11, ProtocolVersion.TLS12}));
        private static final CipherSuiteList clientDefaultCipherSuiteList = SSLContextImpl.access$200(clientDefaultProtocolList, true);

        @Override
        ProtocolList getClientDefaultProtocolList() {
            return clientDefaultProtocolList;
        }

        @Override
        CipherSuiteList getClientDefaultCipherSuiteList() {
            return clientDefaultCipherSuiteList;
        }
    }

    public static final class TLSContext
    extends CustomizedTLSContext {
    }
}

